/*********************************************************************** 
 * timer.h
 * 
 * Project: LPC18xx/LPC43xx common drivers
 * 
 * Description: Timer Driver
 * 
 * Copyright(C) 2010, NXP Semiconductor
 * All rights reserved.
 * 
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only  
 * which provides customers with programming information regarding the  
 * products. This software is supplied "AS IS" without any warranties.  
 * NXP Semiconductors assumes no responsibility or liability for the 
 * use of the software, conveys no license or title under any patent, 
 * copyright, or mask work right to the product. NXP Semiconductors 
 * reserves the right to make changes in the software without 
 * notification. NXP Semiconductors also make no representation or 
 * warranty that such application will be suitable for the specified 
 * use without further testing or modification. 
 **********************************************************************/
#ifndef __TIMER_H 
#define __TIMER_H

#ifdef __cplusplus
 extern "C" {
#endif

/* The test is either MAT_OUT or CAP_IN. Default is MAT_OUT. */
/* If running DMA test program which uses MAT_OUT to trigger DMA, set 
TIMER_MATCH to 1 */
#define TIMER_MATCH     1
    
/* MHZ_PRESCALE is a value to set the prescaler to in order to
   clock the timer at 1 MHz. Clock needs to be a multiple of 1 MHz or
   this will not work. */
#ifdef LPC43XX
  #define MHZ_PRESCALE    (M4Frequency/1000000)
#endif
#ifdef LPC18XX
  #define MHZ_PRESCALE    (M3Frequency/1000000)
#endif

/* TIME_INTERVALmS is a value to load the timer match register with
   to get a 1 mS delay */
#define TIME_INTERVALmS 1000

#define TIME_INTERVAL   (108000000/54000000 - 1)

extern void delayMs(uint8_t timer_num, uint32_t delayInMs);
extern uint32_t init_timer( uint8_t timer_num, uint32_t location, uint32_t timerInterval );
extern void enable_timer( uint8_t timer_num );
extern void disable_timer( uint8_t timer_num );
extern void reset_timer( uint8_t timer_num );
extern void TIMER0_IRQHandler (void);
extern void TIMER1_IRQHandler (void);
extern void TIMER2_IRQHandler (void);
extern void TIMER3_IRQHandler (void);

#ifdef __cplusplus
}
#endif

#endif /* end __TIMER_H */

